#pragma once


#include "WhiteCapWorld.h"
#include "PixPort.h"
#include "FileSpecList.h"
#include "Prefs.h"
#include "XLongList.h"

#if EG_MAC
#include <Files.h>
#endif

#define cWhiteCapID		'WCap'
#define cPluginAuthor	'Av55'

class WhiteCap {

	public:	
		
		// Once you make a new WhiteCap, don't do anything else until you call SetPort() or SetWinRect()
								WhiteCap( CEgFileSpec& inPluginsFolder, void* inRefCon = NULL );
								~WhiteCap();

		// Calling this assumes that the GrafPort WhiteCap has is a window.  This call simply is a 
		// MacOS/Win32 util to get a rect for the OS window size
		void					GetWinRect( Rect& outRect );
		
		// Tell's WhiteCap, "work inside this grafPort and keep your slimy butt inside inRect"
		// inAtFullsceen is needed because WC responds to input differently if it's fullscreen mode vs. no.
		void					SetPort( GrafPtr inPort, const Rect& inRect, bool inAtFullsceen );
		
		// Use this call (instead of SetPort()) when WhiteCap's
		// is in control of its own window (ie, in MacAMP and Winamp)--this call will make a call to
		// SetPort().  In other words, this call is like SetPort() but it also
		// correctly positions WhiteCap's window for you, changing inRect from global cords to local cords
		// If inRect is invalid or NULL, the prefs are used 
		void					SetWinPort( GrafPtr inPort, const Rect* inRect = NULL );
		


		void					RecordSample( long inTime, float inSpectrum[] );

		void					Draw();
		
		void					SetFullScreen( bool inFullScreen );
		inline bool				IsFullScreen()		{ return mAtFullScreen;	}
		
		void					RefreshRect( const Rect& inUpdate );

		void					SelectConfig();

		void					ToggleFrameCounter()					{ mFrameCount = (mFrameCount >= 0) ? -1 : 0;	}


		bool					PtInTitle( Point inPt );

	protected:
		bool					mDoingSetPortWin;	// true when a thread is currently inside SetPortWin()
		Rect					mWinRectHolder;		// Win rect holder while we're n FS mode
		Rect					mDispRect;			// Local cords rect within mOSPort we can draw in
		bool					mMouseWillAwaken;	// true if moving the mouse will exit fullscreen mode
		GrafPtr					mOSPort;
		FileSpecList			mConfigs;
		int						mCurConfigNum;
		XLongList				mConfigPlayList;
		PixPort					mPort;
		long 					mNextShapeChange;
		bool					mInSlideShowMode;
		Prefs					mPrefs;
	
		
		// Plugin prefs
		long					mSlideShowInterval;
		long					mScrnSaverDelay;

		
		// For dumping raw spectrum data
		UtilStr					mDumpData;
				
		#define MAX_WORLDS		10
		long					mNumWorlds;	
		WhiteCapWorld*			mWorld[ MAX_WORLDS ];

		// Stuff dealing with full screen mode
		bool					mAtFullScreen;
		Point					mLastMousePt;
		long					mLastActiveTime;
		long					mFullscreenStartTime;
		
		// Frame rate/calc members.  mFrameCount >= 0 if frame counting/displaying is on
		UtilStr					mFrameRate;
		long					mFramesPer10Secs;
		long					mFrameCountStart;
		long					mFrameCount;
		
		void					BuildConfigList( CEgFileSpec& inPluginsFolder );
		void					LoadConfig( int inConfigNum );
		
		//  Chops up mDispRect into smaller rects, making a rect for each config to be shown.
		void					ResizeWorlds();

		void *					mRefCon;
};